unit CompRect;

interface

uses Classes, Forms, Graphics, Windows,
     Face;

type
  tRectangle = class(tDrawComponent)
  private
  public
    Filled, Invisible: Boolean;
    constructor CreateBy(aOwner: tComponent); override;
    constructor CreateByPoint(aOwner: tComponent; aPoint: tPoint); override;
    procedure GetExtent(var aMin, aMax: tPoint); override;
    function GetRgn: hRgn; override;
    procedure Paint; override;
    procedure SetPropList; override;
  end;

var dciRectangle: Integer;

implementation

uses Dialogs, SysUtils,
     GDIPAPI, GDIPOBJ;

constructor tRectangle.CreateBy(aOwner: tComponent);
begin
  ImageIndex:= 12;
  inherited CreateByBasicName(aOwner, 'Rectangle');
  Color:= clMoneyGreen;
  CreatingByAddPoint:= True;
end;

constructor tRectangle.CreateByPoint(aOwner: tComponent; aPoint: Windows.tPoint);
begin
  CreateBy(aOwner);
  Left:= aPoint.X;
  Top:= aPoint.Y;
end;

procedure tRectangle.GetExtent(var aMin, aMax: Windows.tPoint);
var i: Integer;
begin
  if Left< aMin.X then aMin.X:= Left;
  if (Left+ Width)> aMax.X then aMax.X:= Left+ Width;
  if Top< aMin.Y then aMin.Y:= Top;
  if (Top+ Height)> aMax.Y then aMax.Y:= Top+ Height;
  for i:= 0 to ComponentCount- 1 do
    tDrawComponent(Components[i]).GetExtent(aMin, aMax);
end;

function tRectangle.GetRgn: hRgn;
var R1, R2: TGPRegion;
    myGraphic : TGPGraphics;
    L, T, W, H: Integer;
begin
  if Filled
  then
    Result:= CreateRectRgn(Round(Left* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round(Top* DrawFace.ZoomFactor)- DrawFace.Shift.Y,
            Round((Left+ Width)* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round((Top+ Height)* DrawFace.ZoomFactor)- DrawFace.Shift.Y)
  else
  begin
    L:= Left;
    W:= Width;
    T:= Top;
    H:= Height;
    if Width< 0 then
    begin
      L:= Left+ Width;
      W:= -Width;
    end;
    if Height< 0 then
    begin
      T:= Top+ Height;
      H:= -Height;
    end;
    myGraphic := TGPGraphics.Create(DrawFace.Canvas.Handle);
    R1:= TGPRegion.Create(MakeRect(Round(L* DrawFace.ZoomFactor)- DrawFace.Shift.X- 2,
            Round(T* DrawFace.ZoomFactor)- DrawFace.Shift.Y- 2,
            Round(W* DrawFace.ZoomFactor)+ 4,
            Round(H* DrawFace.ZoomFactor)+ 4));
    R2:= TGPRegion.Create(MakeRect(Round(L* DrawFace.ZoomFactor)- DrawFace.Shift.X+ 2,
            Round(T* DrawFace.ZoomFactor)- DrawFace.Shift.Y+ 2,
            Round(W* DrawFace.ZoomFactor)- 4,
            Round(H* DrawFace.ZoomFactor)- 4));
    R1.Exclude(R2);
    Result:= R1.GetHRGN(myGraphic);
    R1.Free;
    R2.Free;
    myGraphic.Free;
  end;
end;

procedure tRectangle.Paint;
begin
  with DrawFace.Canvas do
  begin
    Brush.Color:= Color;
    if Filled then Brush.Style:= bsSolid
              else Brush.Style:= bsClear;
    Pen.Width:= Round(DrawFace.ZoomFactor* LineWidth);
    if Pen.Width< 1 then Pen.Width:= 1;
    if DrawFace.Printing then Pen.Color:= clBlack
                          else Pen.Color:= LineColor;
    if not Invisible then
      Rectangle(Round(Left* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round(Top * DrawFace.ZoomFactor)- DrawFace.Shift.Y,
            Round((Left+ Width)* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round((Top+ Height)* DrawFace.ZoomFactor)- DrawFace.Shift.Y);
  end;
  inherited;
end;

procedure tRectangle.SetPropList;
begin
  inherited;
  with PropList do
  begin
    Add(tBooleanProp.CreateBooleanProp(@Filled, 'Filled'));
    Add(tBooleanProp.CreateBooleanProp(@Invisible, 'Invisible'));
  end;
end;

initialization

  //dci -> DrawComponentIndex

  dciRectangle:= Face.DrawCompItemList.Add(tDrawCompItem.Create('Rectangle', tRectangle));

end.
